# Ćwiczenie 1

## Zadanie
Utwórz strukturę o nazwie `Person` razem z trzema polami: `FirstName` i `LastName` typu `string` oraz `Age` typu `int`. Utwórz funkcję o nazwie `MakePerson` pobierającą parametry `firstName`, `lastName` i `age` oraz zwracającą strukturę `Person`. Następnie utwórz drugą funkcję o nazwie `MakePersonPointer` pobierającą parametry `firstName`, `lastName` i `age` oraz zwracającą `*Person`. Obie funkcje wywołaj z poziomu funkcji `main`. Program skompiluj z użyciem polecenia `go build -gcflags="-m"`. To spowoduje skompilowanie kodu i wyświetlenie wartości ucieczki do sterty. Czy te wartości są zaskoczeniem?

## Rozwiązanie

Kod jest dość prosty. Jedyna różnica między funkcjami `MakePerson` i `MakePersonPointer` polega na użyciu `&` przed `Person` w poleceniu `return` funkcji `MakePersonPointer`

```go
type Person struct {
	FirstName string
	LastName  string
	Age       int
}

func MakePerson(firstName, lastName string, age int) Person {
	return Person{
		FirstName: firstName,
		LastName:  lastName,
		Age:       age,
	}
}

func MakePersonPointer(firstName, lastName string, age int) *Person {
	return &Person{
		FirstName: firstName,
		LastName:  lastName,
		Age:       age,
	}
}

func main() {
    p := MakePerson("Fred", "Williamson", 25)
    fmt.Println(p)
    p2 := MakePersonPointer("Wilma", "Fredson", 32)
    fmt.Println(p2)
}
```

Kompilacja kodu z użyciem opcji `-gcflags="-m"` powoduje wyświetlenie wartości ucieczki do sterty (a także wskazuje, kiedy funkcja jest osadzona, co będzie rodzajem nieomówionej w książce optymalizacji stosowanej przez kompilator).

````shell
$ go build -gcflags="-m"
# github.com/learning-go-book-2e/ch06/exercise_solutions/ex1
./main.go:11:6: can inline MakePerson
./main.go:19:6: can inline MakePersonPointer
./main.go:28:17: inlining call to MakePerson
./main.go:29:13: inlining call to fmt.Println
./main.go:30:25: inlining call to MakePersonPointer
./main.go:31:13: inlining call to fmt.Println
./main.go:11:17: leaking param: firstName to result ~r0 level=0
./main.go:11:28: leaking param: lastName to result ~r0 level=0
./main.go:19:24: leaking param: firstName
./main.go:19:35: leaking param: lastName
./main.go:20:9: &Person{...} escapes to heap
./main.go:29:13: ... argument does not escape
./main.go:29:14: p escapes to heap
./main.go:30:25: &Person{...} escapes to heap
./main.go:31:13: ... argument does not escape
````

Wartość `&Person{}` zwrócona przez `MakePersonPointer` ucieka do sterty. Każdy wskaźnik zwrócony przez funkcję wraca do sterty, przy czym wskazywana przez niego wartość musi być przechowywana na stercie.

Zaskakujące może być to, że `p` również ucieka do sterty. Powód jest prosty - przekazanie do `fmt.Println` wiąże się z tym, że parametrem `fmt.Println` jest `...any`. Obecna wersja kompilatora Go przenosi do stery każdą wartość, która jest przekazywana funkcji za pomocą parametru typu interfejsu. (Interfejsy zostały omówione w rozdziale 7.).